unit Fourier01;
interface
uses MainData, Math, Report01;
// ==============================================================
//    
// ==============================================================
// --------------------------------------------------------------
//      
//  FourierKoeff (,)   X
function  CalcFourierFuncAB(RqX : extended) : extended;
// --------------------------------------------------------------
//       BasisSelectList,
//    FourierKoeff   X
function BasisCalcFourierFuncAB
        (RqSelectKoeff : boolean; RqX : extended) : extended;
// --------------------------------------------------------------
//   MaxKoeffInd   
//       FourierKoeff
procedure CalcFourierKoeff (MaxKoeffInd : word);


// ==============================================================
//                     .
// ==============================================================
implementation
// --------------------------------------------------------------
//  03.11.2008.
//      
//  FourierKoeff (,)   X
function CalcFourierFuncAB(RqX : extended) : extended;
var Ind       : word;
    Omega     : extended;
    FuncValue : extended;
begin
 CalcFourierFuncAB := 0;
 if Length (FourierKoeff) > 0
 then begin
   if Abs(FourierPeriod) > 1.0E-300
   then begin
     Omega:=(2*Pi)/FourierPeriod;
     FuncValue := FourierKoeff[Low(FourierKoeff)].BKoeff;
     for Ind := Low(FourierKoeff) + 1 to High(FourierKoeff) do
     begin
       FuncValue := FuncValue
               + FourierKoeff[Ind].AKoeff * SIN(Ind * Omega * RqX)
               + FourierKoeff[Ind].BKoeff * COS(Ind * Omega * RqX);
     end;
     CalcFourierFuncAB := FuncValue;
   end;
 end
 else begin
   DebugErrorToReport ('Fourier01.CalcFourierFuncAB: '
                    +  '      '
                    +  '  ');
 end;
end;

// --------------------------------------------------------------
//  03.11.2008.
//       BasisSelectList,
//    FourierKoeff   X
function BasisCalcFourierFuncAB
        (RqSelectKoeff : boolean; RqX : extended) : extended;
var Ind       : integer;
    Omega     : extended;
    FuncValue : extended;
    FlagBasis : boolean;
begin
 BasisCalcFourierFuncAB := 0;
 //        
 FlagBasis := False;
 if (RqSelectKoeff)
 then begin
   if Length(BasisSelectList) > 0
   then begin
     for Ind := Low(BasisSelectList) to High(BasisSelectList) do
     begin
        if (BasisSelectList[Ind] = True)
        then begin
          //  
          FlagBasis := True;
          Break;
        end;
     end;
   end;
 end;  
 // ------------------------------
 if FlagBasis and (Length(FourierKoeff) = Length(BasisSelectList))
 then begin
   if Abs(FourierPeriod) > 1.0E-300
   then begin
     //      
     Omega:=(2*Pi)/FourierPeriod;
     FuncValue := 0;
     if Length(FourierKoeff) > 0 then
     begin
       for Ind := Low(FourierKoeff) to High(FourierKoeff) do
       begin
         if (BasisSelectList[Ind])
         then begin
            if Ind = Low(FourierKoeff)
            then begin
              FuncValue := FourierKoeff[Ind].BKoeff;
            end
            else begin
              FuncValue := FuncValue
               + FourierKoeff[Ind].AKoeff * SIN(Ind * Omega * RqX)
               + FourierKoeff[Ind].BKoeff * COS(Ind * Omega * RqX);
            end;
         end;
       end; // of for Ind
     end;
     BasisCalcFourierFuncAB := FuncValue;
   end;
 end
 else begin
   //     
   //    
   BasisCalcFourierFuncAB := CalcFourierFuncAB(RqX);
 end;
end; // of function

// --------------------------------------------------------------
//  13.10.2008.  29.06.20011.
//   MaxKoeffInd -   
//       FourierKoeff
procedure CalcFourierKoeff (MaxKoeffInd : word);
var MInd, Ind        : word;
    XPre, XCur       : extended;
    DX               : extended;
    YPre, YCur       : extended;
    ASum, BSum       : extended;
    wAmp, wPhs       : extended;
    Omega  : extended;
begin
    if (Length(TableFuncionArray) > 2) and (MaxKoeffInd > 0)
    then begin
      SetLength(FourierKoeff, MaxKoeffInd + 1);
      FourierPeriod := TableFuncionArray[High(TableFuncionArray)].X
                     - TableFuncionArray[Low(TableFuncionArray)].X;
      if Abs(FourierPeriod) > 1.0E-300
      then begin
        Omega:=(2*Pi)/FourierPeriod;

        for MInd:=Low(FourierKoeff) to High(FourierKoeff) do
        begin
          ASum:=0;
          BSum:=0;
          for Ind:= Low(TableFuncionArray) to High(TableFuncionArray) do
          begin
            //     
            //   
            if Ind > Low(TableFuncionArray)
            then begin
               XPre := TableFuncionArray[Ind-1].X;
               XCur := TableFuncionArray[Ind].X;
               DX := XCur -XPre;
               YPre := TableFuncionArray[Ind-1].Y;
               YCur := TableFuncionArray[Ind].Y;
               if MInd = Low(FourierKoeff)
               then begin
                 BSum := BSum  + (( YCur + YPre)* DX /2);
               end
               else begin
                 ASum := ASum
                   + (( YCur*sin(MInd*Omega*XCur) + YPre*sin(MInd*Omega*XPre) )
                   * DX /2 );
                 BSum := BSum
                   + (( YCur*cos(MInd*Omega*XCur) + YPre*cos(MInd*Omega*XPre) )
                   * DX /2 );
               end;
            end;
          end; // for
          //   An  Bn
          if MInd = Low(FourierKoeff)
          then begin
             FourierKoeff[MInd].AKoeff := 0;
             FourierKoeff[MInd].BKoeff := BSum / FourierPeriod
          end
          else begin
             FourierKoeff[MInd].AKoeff := 2 * ASum / FourierPeriod;
             FourierKoeff[MInd].BKoeff := 2 * BSum / FourierPeriod;
          end;
          // ----- 29.06.20011 ----------------------------
          //     
          // Un = Cn * SIN ( n * ( 2 * Pi / Period) * X  + Pn);
          //--------------------------------------------------------
          //   Cn = Sqrt( An^2 + Bn^2)
          FourierKoeff[MInd].CKoeff := Sqrt(
                                  IntPower(FourierKoeff[MInd].AKoeff,2)
                               +  IntPower(FourierKoeff[MInd].BKoeff,2)
                                          );
          //      Abs(Arcsin(Bn/Cn));
          if MInd = Low(FourierKoeff)
          then FourierKoeff[MInd].PKoeff := 0
          else begin
             wAmp := FourierKoeff[MInd].CKoeff;
             wPhs := 0;
             if wAmp > 1e-10       //   
             then begin
                // I 
                wPhs := ARCSIN(Abs(FourierKoeff[MInd].BKoeff) / wAmp);
                if FourierKoeff[MInd].BKoeff >= 0
                then begin         // I  II    ( b + )
                   if FourierKoeff[MInd].AKoeff < 0
                   then wPhs := Pi - wPhs;       // II 
                end
                else begin         // III  IV  ( b - )
                   if FourierKoeff[MInd].AKoeff < 0
                   then wPhs := wPhs + Pi        // III 
                   else wPhs := 2 * Pi - wPhs;   // IV  
               end;
             end
             else FourierKoeff[MInd].CKoeff := 0;
             FourierKoeff[MInd].PKoeff := wPhs;
          end;
          //--------------------------------------------------------
        end; //for

      end; // Period <> 0
    end;
end;
// ==========================================================
// IMPLEMENTATION END
// ==========================================================

end.
